<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ForumBoard;
use App\Models\ForumCategory;
use Illuminate\Support\Str;

class ForumBoardSeeder extends Seeder
{
    public function run(): void
    {
        $boards = [
            // General GMod Discussion category
            [
                'category_name' => 'General GMod Discussion',
                'boards' => [
                    [
                        'name' => 'Announcements',
                        'description' => 'Important GMod announcements and updates',
                        'order' => 1,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'General Discussion',
                        'description' => 'General talk about Garry\'s Mod',
                        'order' => 2,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Help & Support',
                        'description' => 'Get help with GMod issues and questions',
                        'order' => 3,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Media Showcase',
                        'description' => 'Share your GMod screenshots, videos, and artwork',
                        'order' => 4,
                        'is_active' => true,
                    ],
                ]
            ],
            
            // Roleplay category
            [
                'category_name' => 'Roleplay',
                'boards' => [
                    [
                        'name' => 'DarkRP',
                        'description' => 'Discussion about DarkRP gamemode',
                        'order' => 1,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'PoliceRP',
                        'description' => 'Discussion about PoliceRP gamemode',
                        'order' => 2,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'MilitaryRP',
                        'description' => 'Discussion about MilitaryRP gamemode',
                        'order' => 3,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'TTT',
                        'description' => 'Discussion about Trouble in Terrorist Town',
                        'order' => 4,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Other Roleplay',
                        'description' => 'Discussion about other RP gamemodes',
                        'order' => 5,
                        'is_active' => true,
                    ],
                ]
            ],
            
            // Addons & Development category
            [
                'category_name' => 'Addons & Development',
                'boards' => [
                    [
                        'name' => 'Lua Scripting',
                        'description' => 'GMod Lua scripting help and discussions',
                        'order' => 1,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Addon Releases',
                        'description' => 'Released GMod addons and scripts',
                        'order' => 2,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Addon Requests',
                        'description' => 'Request GMod addons and scripts',
                        'order' => 3,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Map Development',
                        'description' => 'GMod mapping and level design',
                        'order' => 4,
                        'is_active' => true,
                    ],
                ]
            ],
            
            // Servers category
            [
                'category_name' => 'Servers',
                'boards' => [
                    [
                        'name' => 'Server Advertisements',
                        'description' => 'Advertise your GMod server here',
                        'order' => 1,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Server Administration',
                        'description' => 'Help with managing GMod servers',
                        'order' => 2,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Server Issues',
                        'description' => 'Get help with server problems',
                        'order' => 3,
                        'is_active' => true,
                    ],
                ]
            ],
            
            // Off-Topic category
            [
                'category_name' => 'Off-Topic',
                'boards' => [
                    [
                        'name' => 'Off-Topic Discussion',
                        'description' => 'Talk about anything not related to GMod',
                        'order' => 1,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Gaming Discussion',
                        'description' => 'Talk about other games',
                        'order' => 2,
                        'is_active' => true,
                    ],
                    [
                        'name' => 'Hardware & Software',
                        'description' => 'PC hardware and software discussions',
                        'order' => 3,
                        'is_active' => true,
                    ],
                ]
            ],
        ];

        foreach ($boards as $categoryBoards) {
            $category = ForumCategory::where('name', $categoryBoards['category_name'])->first();
            
            if ($category) {
                foreach ($categoryBoards['boards'] as $board) {
                    ForumBoard::create([
                        'category_id' => $category->id,
                        'name' => $board['name'],
                        'slug' => Str::slug($board['name']),
                        'description' => $board['description'],
                        'order' => $board['order'],
                        'is_active' => $board['is_active'],
                    ]);
                }
            }
        }
    }
}